//
//  GMSRequestViewController.m
//  GMS Sample
//
/*
 Version: 1.0
 
 Disclaimer: IMPORTANT:  This software is supplied to you by Genesys
 Telecommunications Laboratories Inc ("Genesys") in consideration of your agreement
 to the following terms, and your use, installation, modification or redistribution
 of this Genesys software constitutes acceptance of these terms.  If you do not
 agree with these terms, please do not use, install, modify or redistribute this
 Genesys software.
 
 In consideration of your agreement to abide by the following terms, and subject
 to these terms, Genesys grants you a personal, non-exclusive license, under
 Genesys's copyrights in this original Genesys software (the "Genesys Software"), to
 use, reproduce, modify and redistribute the Genesys Software, with or without
 modifications, in source and/or binary forms; provided that if you redistribute
 the Genesys Software in its entirety and without modifications, you must retain
 this notice and the following text and disclaimers in all such redistributions
 of the Genesys Software.
 
 Neither the name, trademarks, service marks or logos of Genesys Inc. may be used
 to endorse or promote products derived from the Genesys Software without specific
 prior written permission from Genesys.  Except as expressly stated in this notice,
 no other rights or licenses, express or implied, are granted by Genesys herein,
 including but not limited to any patent rights that may be infringed by your
 derivative works or by other works in which the Genesys Software may be
 incorporated.
 
 The Genesys Software is provided by Genesys on an "AS IS" basis.  GENESYS MAKES NO
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, REGARDING THE GENESYS SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
 COMBINATION WITH YOUR PRODUCTS.
 
 IN NO EVENT SHALL GENESYS BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR
 DISTRIBUTION OF THE GENESYS SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF
 CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF
 GENESYS HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
 Copyright (C) 2013 Genesys Inc. All Rights Reserved.
 */

#import "GMSRequestViewController.h"
#import "GMSAppDelegate.h"
#import "GMSLogViewController.h"
#import "GMSChatViewController.h"
#import "GMSSettingsSelectViewController.h"
#import "GMSSettingsTableViewController.h"


@implementation GMSRequestViewController
{
    UIImagePickerController *imagePicker;
    BOOL imagePicked;
}

#pragma mark -
#pragma mark View LifeCycle

- (id)initWithCoder:(NSCoder*)coder
{
    if ((self = [super initWithCoder:coder])) {
        //We need to create GMSDmenu here, in case of APN. initWithCoder is called before AppDidFinishLaunching, where we use dMenu.
        self.dMenu = [GMSDMenu initWithObject:self.navigationController];
    }
    return self;
}

- (void)viewDidLoad
{

    [super viewDidLoad];

    GMSAppDelegate *appDelegate = (GMSAppDelegate*)[[UIApplication sharedApplication] delegate];
    
    // Custom initialization
    _userNameTextField.text = appDelegate.userID;
    _pwdTextField.text = appDelegate.userPwd;
    _way2Connect.text = appDelegate.way2Connect;
    _infoLevel.text = appDelegate.problemInfoLevel;
    _contentTextField.text = appDelegate.problemContent;
    _appPathTextField.text = appDelegate.appPath;
    	    
    imagePicker = [[UIImagePickerController alloc] init];
    imagePicker.allowsEditing = NO;
    imagePicker.delegate = self;
    if (![UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]) {
        // camera is not on this device, don't show the camera button
        _takePictureButton.enabled = NO;
    }
    imagePicked = NO;
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewDidUnload {
    imagePicker = nil;    
    [self setTakePictureButton:nil];
    [self setImageView:nil];
    [self setSubmitButton:nil];
    [self setWay2Connect:nil];
    [self setInfoLevel:nil];
    [self setSubmitButton:nil];
    [self setUserNameTextField:nil];
    [self setPwdTextField:nil];
    [self setContentTextField:nil];
    [self setAppPathTextField:nil];
    [self setWay2Connect:nil];
    [super viewDidUnload];
}


#pragma mark -
#pragma mark Photo Actions


- (IBAction)takePhoto:(id)sender {
    imagePicker.sourceType = UIImagePickerControllerSourceTypeCamera;
    [self.navigationController presentModalViewController:imagePicker animated:YES];
}

- (IBAction)choosePhoto:(id)sender {
    imagePicker.sourceType = UIImagePickerControllerSourceTypeSavedPhotosAlbum;
    [self.navigationController presentModalViewController:imagePicker animated:YES];
}

- (IBAction)clearPhoto:(id)sender {
    imagePicked = NO;
    _imageView.image = [UIImage imageWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"placeholder" ofType:@"png"]];
}

#pragma mark -
#pragma mark UIImagePickerControllerDelegate

// this get called when an image has been chosen from the library or taken from the camera
//
- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info
{
    _imageView.image = [info valueForKey:UIImagePickerControllerOriginalImage];
    imagePicked = YES;
    [picker dismissModalViewControllerAnimated:YES];
}

- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker
{
     [picker dismissModalViewControllerAnimated:YES];
}


#pragma mark -
#pragma mark - TextField delegates

- (void)updateFromTextField:(UITextField *)textField textToUpdate:(NSString *)txtStr {
    GMSAppDelegate *appDelegate = (GMSAppDelegate*)[[UIApplication sharedApplication] delegate];
    if (textField == _userNameTextField) {
        appDelegate.userID = txtStr;
    }
    else if (textField == _pwdTextField) {
        appDelegate.userPwd = txtStr;
    }
    else if (textField == _contentTextField) {
        appDelegate.problemContent = textField.text;
    }
    else if (textField == _appPathTextField) {
        appDelegate.appPath = txtStr;
    }
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    [self updateFromTextField:textField textToUpdate:textField.text];
}

- (BOOL)textFieldShouldClear:(UITextField *)textField {
    [self updateFromTextField:textField textToUpdate:@""];
    return YES;
}

//Dismiss keyboard when Return key is pressed
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    [textField resignFirstResponder];
    return YES;
}

- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)replacementStr {
    NSString *proposedNewString = [[textField text] stringByReplacingCharactersInRange:range withString:replacementStr];
    [self updateFromTextField:textField textToUpdate:proposedNewString];
    return YES;
}

//find Chat View Controller in Tab Bar
- (GMSChatViewController *)findChatController {
    for (id vc in [super tabBarController].viewControllers) {
        if ([vc isKindOfClass:[GMSChatViewController class]] ) {
            return vc;
        }
    }
    return nil;
}

- (IBAction)submitGMS:(id)sender {
    
    NSMutableDictionary *params = [[NSMutableDictionary alloc] init];
    
    NSDateFormatter *dateFormat = [[NSDateFormatter alloc] init];
    [dateFormat setDateFormat:@"dd-MMM-YYYY HH:mm z"];
        
    GMSAppDelegate *appDelegate = (GMSAppDelegate*)[[UIApplication sharedApplication] delegate];
    
//    //Remove non-digits from phone
//    NSString *phoneN = appDelegate.contactNumber;
//    phoneN = [phoneN stringByReplacingOccurrencesOfString:@"[^0-9]"
//                                               withString:@""
//                                                  options:NSRegularExpressionSearch
//                                                    range:NSMakeRange(0, [phoneN length])];
//    //Remove leading "1"
//    if ([phoneN length] == 11 && [phoneN hasPrefix:@"1"]) {
//        phoneN = [phoneN substringFromIndex:1];
//    }

    //Add parameter for simulated APN from Settings
    if ([sender isKindOfClass:[GMSSettingsTableViewController class]]) {
        [params setValue:@"true" forKey:@"_simulate_proactive_event"];                                              //Simulate proactive APN
    }

#if (TARGET_IPHONE_SIMULATOR)
    [params setValue:@"comet" forKey:@"_device_os"];
#else
    [params setValue:@"ios" forKey:@"_device_os"];
#endif
    [params setValue:appDelegate.notifyToken forKey:@"_device_notification_id"];                                    //APN Token
    [params setValue:(appDelegate.serverAPNDebug) ? @"true" : @"false" forKey:@"_use_debug_push_certificate"];
    [params setValue:appDelegate.userID forKey:@"_chat_user_display_name"];                                         //User ID
    [params setValue:appDelegate.userID forKey:@"userDisplayName"];                                                 //User ID
    [params setValue:appDelegate.userPwd forKey:@"_user_password"];                                                 //User Password
    [params setValue:appDelegate.problemInfoLevel forKey:@"_problem_info_level"];                                   //Problem Info Level
    [params setValue:appDelegate.problemContent forKey:@"_problem"];                                                //Problem Content
    [params setValue:appDelegate.appPath forKey:@"_app_path"];                                                      //Application Path
    [params setValue:appDelegate.customerSegment forKey:@"_customer_segment"];                                      //Customer Segment
    [params setValue:appDelegate.themeFlavor forKey:@"_theme_flavor"];                                              //Theme Flavor
    [params setValue:appDelegate.contactNumber forKey:@"_customer_number"];                                         //Contact Number
    [params setValue:[[NSLocale preferredLanguages] objectAtIndex:0] forKey:@"_language"];                          //Language Selected
    [params setValue:[NSString stringWithFormat:@"%f", appDelegate.location.latitude] forKey:@"_location_lat"];     //Location
    [params setValue:[NSString stringWithFormat:@"%f", appDelegate.location.longitude] forKey:@"_location_long"];
    [params setValue:[dateFormat stringFromDate:appDelegate.date] forKey:@"_date"];                                 //Date

    if (![appDelegate.way2Connect isEqualToString:@"SERVER-DECIDE"]) {
        if ([appDelegate.way2Connect rangeOfString:@"WAIT"].location == NSNotFound)
            [params setValue:@"false" forKey:@"_wait_for_agent"];                                                   //Way to connect
        else
            [params setValue:@"true" forKey:@"_wait_for_agent"];                                                    //Way to connect
        
        if ([appDelegate.way2Connect hasSuffix:@"USERTERM"])                                                        //Call Direction
            [params setValue:@"USERTERMINATED" forKey:@"_call_direction"];
        else                                                                                                        //Call Direction
            [params setValue:@"USERORIGINATED" forKey:@"_call_direction"];
        
        if ([appDelegate.way2Connect hasPrefix:@"CHAT"]) {                                                          //Chat
            [params setValue:@"chat" forKey:@"_media_type"];
            [params setValue:@"GMS Sample" forKey:@"subject"];                                                      //Chat Subject
        }
        else
            [params setValue:@"voice" forKey:@"_media_type"];
    }
    
    [params setValue:@"CUSTOMER" forKey:@"_call_origination"];                                                      //Call Origination
    [params setValue:(appDelegate.loginRequired) ? @"true" : @"false" forKey:@"_login_required"];                   //Login required
    [params setValue:(appDelegate.provideCode) ? @"true" : @"false" forKey:@"_provide_code"];                       //Provide DTMF code
    if (imagePicked) {
        NSData *photoData = UIImagePNGRepresentation(_imageView.image);                                             //Photo
        [params setValue:photoData forKey:@"_photo"];
    }
    
    _submitButton.enabled = NO;

    _dMenu.audioEnabled = appDelegate.audioEnabled;
    _dMenu.audioRecordEnabled = appDelegate.audioRecordEnabled;
    __weak UIBarButtonItem *wButton = _submitButton;
    _dMenu.completionBlock = ^(NSDictionary *responseDict){
        wButton.enabled = YES;
        if ([responseDict isKindOfClass:[NSDictionary class]]) {
            appDelegate.serviceID = responseDict[@"_id"];
        }
    };
    
    GMSChatViewController *vc = [self findChatController];
    _dMenu.startChatBlock = ^(NSDictionary *actionDict){
        //Start Chat
        [vc startWithURL:actionDict[@"_start_chat_url"]
                cometURL:actionDict[@"_comet_url"]
              userHeader:actionDict[@"_user_header"]
              chatParams:actionDict[@"_chat_parameters"]];
        [super tabBarController].selectedViewController = vc;
    };
    _dMenu.endChatBlock = ^{
        [vc endChat:nil];
    };
    [_dMenu submitRequest2GMS:appDelegate.serverURLs[appDelegate.serverURLSelected] method:@"POST" params:params headers:@{@"gms_user" : appDelegate.userID}];
}

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    GMSAppDelegate *appDelegate = (GMSAppDelegate*)[[UIApplication sharedApplication] delegate];
    GMSSettingsSelectViewController *segmentVC = segue.destinationViewController;
    
    if ([segue.identifier isEqualToString:@"informationLevel"]) {
        segmentVC.currentSelection = _infoLevel;
        segmentVC.updateBlock = ^(NSString *title){
            appDelegate.problemInfoLevel = title;
        };
    }

    if ([segue.identifier isEqualToString:@"way2Connect"]) {
        segmentVC.currentSelection = _way2Connect;
        segmentVC.updateBlock = ^(NSString *title){
            appDelegate.way2Connect = title;
        };
    }

}

@end
